      SUBROUTINE DEZFTI(N,WSAVE)   
C***BEGIN PROLOGUE  DEZFTI    
C***DATE WRITTEN   790601   (YYMMDD)    
C***REVISION DATE  860115   (YYMMDD)    
C***CATEGORY NO.  J1A1   
C***KEYWORDS  FOURIER TRANSFORM    
C***AUTHOR  SWARZTRAUBER, P. N., (NCAR) 
C***PURPOSE  Initialize DEZFTF and DEZFTB    
C***DESCRIPTION
C    
C  Subroutine DEZFTI initializes the array WSAVE which is used in
C  both DEZFTF and DEZFTB.  The prime factorization of N together with
C  a tabulation of the trigonometric functions are computed and  
C  stored in WSAVE. 
C    
C  Input Parameter  
C    
C  N       the length of the sequence to be transformed.    
C    
C  Output Parameter 
C    
C  WSAVE   a work array which must be dimensioned at least 3*N+15.    
C          The same work array can be used for both DEZFTF and DEZFTB 
C          as long as N remains unchanged.  Different WSAVE arrays    
C          are required for different values of N.
C***REFERENCES  (NONE)   
C***ROUTINES CALLED  DEZFT1   
C***END PROLOGUE  DEZFTI 
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DIMENSION       WSAVE(*)
C***FIRST EXECUTABLE STATEMENT  DEZFTI  
      IF (N .EQ. 1) RETURN    
      CALL DEZFT1 (N,WSAVE(2*N+1),WSAVE(3*N+1))   
      RETURN   
      END 
